Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = 125.44, y = 178.44, z = 0, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["accept_offer"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_accept_offer", 
	type = "quest", 
}

Triggers["activate_final_speech"] = 
{
	active = true, 
	effect_radius = 3.0, 
	position = { x = 7.7, y = 7.8, z = -3.3, f = 1.0}, 
	priority = 1.0, 
	think = "tf_activate_final_speech", 
	type = "quest", 
}

Triggers["army_reinforce_from_base"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_army_reinforce_from_base", 
	type = "quest", 
}

Triggers["army_reinforce_from_base_set"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_army_reinforce_from_base_set", 
	type = "quest", 
}

Triggers["army_reinforce_from_coast"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_army_reinforce_from_coast", 
	type = "quest", 
}

Triggers["army_reinforce_from_coast_set"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_army_reinforce_from_coast_set", 
	type = "quest", 
}

Triggers["army_set"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_army_set", 
	type = "quest", 
}

Triggers["call_for_reinforce"] = 
{
	active = true, 
	effect_radius = 6, 
	position = { y=59.3, x=0, z=0, f=1 }, 
	priority = 1, 
	think = "tf_call_for_reinforce", 
	type = "quest", 
}

Triggers["campaign"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=-51, x=-40.8, z=4.8, f=1 }, 
	priority = 1, 
	think = "tf_campaign", 
	type = "quest", 
}

Triggers["corp_set"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_corp_set", 
	type = "quest", 
}

Triggers["emergency_exit"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_emergency_exit", 
	type = "quest", 
}

Triggers["final_fight"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_final_fight", 
	type = "quest", 
}

Triggers["mission"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_mission", 
	type = "quest", 
}

Triggers["on_start"] = 
{
	active = true, 
	effect_radius = 8, 
	position = { y=79.6, x=2.5, z=-0.3, f=1 }, 
	priority = 1, 
	think = "tf_on_start", 
	type = "quest", 
}

Triggers["patrol_0"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "circle", 
	point_count = 24, 
	point_radius = 0.5, 
	position = { y=2.8, x=-41, z=0, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=-40.993, y=2.78711, z=0.00137329},{ x=-40.5953, y=25.3957, z=0.00137138},{ x=-34.771, y=34.9982, z=0.0013752},{ x=-30.962, y=38.1046, z=0.00137138},{ x=-7.79415, y=38.6341, z=0.00137138},{ x=7.07038, y=38.3769, z=0.00137138},{ x=30.2627, y=38.3749, z=0.00137138},{ x=41.2695, y=28.2918, z=0.00137138},{ x=41.5794, y=-4.13041, z=0.00137138},{ x=41.2075, y=-8.66118, z=0.00137138},{ x=41.0252, y=-21.7365, z=0.00136948},{ x=31.3599, y=-31.3076, z=0.0013752},{ x=16.7767, y=-32.8068, z=0.00136948},{ x=14.72, y=-36.0408, z=0.00137329},{ x=11.9695, y=-45.9733, z=0.00136948},{ x=5.3365, y=-50.2533, z=0.00137138},{ x=0.0102997, y=-50.7974, z=0.00136757},{ x=-10.2295, y=-46.5368, z=0.00137329},{ x=-14.463, y=-39.096, z=0.00136948},{ x=-15.0198, y=-35.2166, z=0.00137138},{ x=-19.8184, y=-30.6663, z=0.00137329},{ x=-30.8667, y=-31.4348, z=0.00137138},{ x=-40.9895, y=-21.5148, z=0.00136948},{ x=-40.8399, y=-6.19103, z=0.00137329} }
}

Triggers["patrol_1"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "once", 
	point_count = 8, 
	point_radius = 0.5, 
	position = { y=-58.8, x=-61.7, z=-0.1, f=1 }, 
	transfer_mode = "run", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=-61.6703, y=-58.8019, z=-0.0971737},{ x=-65.2328, y=-19.8534, z=-0.349541},{ x=-66.4727, y=24.1452, z=-3.8147e-06},{ x=-58.5723, y=50.0652, z=1.90735e-06},{ x=-38.4584, y=60.2164, z=-0.468985},{ x=-19.3687, y=60.5248, z=-0.211998},{ x=-1.10626, y=61.9154, z=1.90735e-06},{ x=-0.379149, y=40.9719, z=0.00136757} }
}

Triggers["patrol_2"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "once", 
	point_count = 10, 
	point_radius = 0.5, 
	position = { y=8.3, x=72.7, z=-0.7, f=1 }, 
	transfer_mode = "run", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=72.6545, y=8.31442, z=-0.724792},{ x=62.9887, y=12.4014, z=-0.24963},{ x=60.7168, y=28.3587, z=-0.145973},{ x=61.372, y=40.1347, z=-0.0528755},{ x=51.2019, y=56.5907, z=-0.0721588},{ x=40.8331, y=59.951, z=-0.188093},{ x=30.9943, y=61.3923, z=-0.177919},{ x=2.56548, y=61.8216, z=0},{ x=-0.61333, y=49.0309, z=0.00136757},{ x=-1.03848, y=36.875, z=0.00137138} }
}

Triggers["relations_vs_army"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations_vs_army", 
	type = "quest", 
}

trigger_functions =
{
tf_accept_offer = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false

		changeLocalRelations(ALLY, "boss")
		changeLocalRelations(ALLY, ARMY)
		
		setRelations(ARMY, PLAYER, ALLY)
		setRelations(ARMY, BUTSI, ENEMY)
		setRelations(ARMY, MARAUDERS, ENEMY)
		setRelations(ARMY, PIRATS, ENEMY)
		setRelations(ARMY, CORP, ENEMY)
		setRelations(ARMY, REBELS, ENEMY)

		setRelations(BUTSI, PLAYER, ENEMY)
		setRelations(MARAUDERS, PLAYER, ENEMY)
		setRelations(PIRATS, PLAYER, ENEMY)
		setRelations(CORP, PLAYER, ENEMY)
		setRelations(REBELS, PLAYER, ENEMY)

		setGVAR("GLOBAL_WAR_BEGAN", _NO)

		Sectors.palace.owner = ARMY
		maximizeDefence(CURRENT_ALLY)
		setGVAR("CURRENT_ALLY", _ARMY)
		addEntry("j_dic_00", false)

		Sectors.north_base.enabled = true
		Sectors.mountain_village.enabled = true
		Sectors.mines.enabled = true
		Sectors.dam.enabled = true
		Sectors.roadblock.enabled = true
		Sectors.trainstation.enabled = true
		Sectors.detour_road.enabled = true
		Sectors.airport.enabled = true
		Sectors.road_to_airport.enabled = true
		Sectors.coastal_city.enabled = true
		Sectors.coastal_fortress.enabled = true
		Sectors.port.enabled = true
		Sectors.palace.enabled = true
		Sectors.south_village.enabled = true
		Sectors.stream.enabled = true
		Sectors.crossroads.enabled = true
		Sectors.base.enabled = true
		Sectors.pirate_island.enabled = true
		Sectors.outpost.enabled = true
	end
end,
tf_activate_final_speech = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
--		if(trigger_utility.isPlayerPresent(trigger_id,PLAYER) ) then
--			if ( (getGVAR("spawn_boss_pp") == _YES) ) then
--				if ( healthOK("boss") ) then
--					startDlg("dictator","boss", getClosestMerc("boss", CUR_MISSION.Mercs))
--				end
--			end			
--			trigger.active = false
--		end
	end
end,
tf_army_reinforce_from_base_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
	
--		local size = table.getn(base_sldrs)
--		for i=1, size, 1 do
--			log ("palace", ">>base_sldrs[i]	", base_sldrs[i])			
--			local index = base_sldrs[i]
--!	functionality does not work ATM
--			Humans[index].patrol_routine = "patrol_1"
--		end
		
		trigger.active = false
	end
end,
tf_army_reinforce_from_base_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
	
--		local size = table.getn(base_sldrs)
--		for i=1, size, 1 do
--			log ("palace", ">>base_sldrs[i]	", base_sldrs[i])			
--			local index = base_sldrs[i]
--!	functionality does not work ATM
--			Humans[index].patrol_routine = "patrol_1"
--		end
		
		trigger.active = false
	end
end,
tf_army_reinforce_from_coast_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
	
--		local size = table.getn(coast_sldrs)
--		for i=1, size, 1 do
--			log ("palace", ">>coast_sldrs[i]	", coast_sldrs[i])			
--			local index = coast_sldrs[i]
--!	functionality does not work ATM
--			Humans[index].patrol_routine = "patrol_2"
--		end
		
		trigger.active = false
	end
end,
tf_army_reinforce_from_coast_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
	
--		local size = table.getn(coast_sldrs)
--		for i=1, size, 1 do
--			log ("palace", ">>coast_sldrs[i]	", coast_sldrs[i])			
--			local index = coast_sldrs[i]
--!	functionality does not work ATM
--			Humans[index].patrol_routine = "patrol_2"
--		end
		
		trigger.active = false
	end
end,
tf_army_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
--		Humans["army_5"].patrol_routine = "patrol_0"
--		Humans["army_6"].patrol_routine = "patrol_0"
--		Humans["army_7"].patrol_routine = "patrol_0"		
		trigger.active = false
	end
end,
tf_call_for_reinforce = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,PLAYER) ) then
			if ARMY == Sectors.base.owner then
				Triggers["army_reinforce_from_base"].active = true
			end
			if ARMY == Sectors.port.owner then
				Triggers["army_reinforce_from_coast"].active = true
			end		
			trigger.active = false
		end
	end
end,
tf_campaign = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		if ARMY == Sectors.palace.owner then
			Triggers["army_set"].active = true
			Triggers["mission"].active = true
		end		
		if CORP == Sectors.palace.owner then
			Triggers["corp_set"].active = true
		end			
	end
end,
tf_corp_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
	end
end,
tf_emergency_exit = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
--		Sectors.palace.isEscaped = true
		finishMission()
		trigger.active = false
	end
end,
tf_final_fight = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		changeLocalRelations(ENEMY, "boss")
	end
end,
tf_mission = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		if Sectors.palace.isDone then return end
		if 0 == getGVAR("isRT") then return end
		if ARMY ~= Sectors.palace.owner then return end
		
--		startDlg("docu_check","army_3",CUR_MISSION.Mercs[1])
	end
end,
tf_on_start = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,PLAYER) ) then			
			Triggers["campaign"].active = true
			trigger.active = false
		end
	end
end,
tf_relations_vs_army = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
			changeLocalRelations(ENEMY, ARMY)		
			
--			changeLocalRelations(ALLY, "army")		
		trigger.active = false
	end
end,
tf_army_reinforce_from_base = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		
--		base_off = spawnPersons("army", "bbb", "palace_def_officer", 1)
--		base_sldrs = spawnPersons("army", "bbb", "palace_def_solider", 5)
		
--		Triggers["army_reinforce_from_base_set"].active = true
			
--		Sectors[CUR_MISSION.Name].onUpdate()
	end
end,
tf_army_reinforce_from_coast = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		
--		coast_off = spawnPersons("army", "ccc", "palace_def_officer", 1)
--		coast_sldrs = spawnPersons("army", "ccc", "palace_def_solider", 5)	
		
--		Triggers["army_reinforce_from_coast_set"].active = true	
		
--		Sectors[CUR_MISSION.Name].onUpdate()
	end
end,
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
}
